# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: C

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    last_opp_move = opp_history[-1] if opp_history else "C"
    
    # Early rounds (1-3): Cooperate to establish goodwill
    if current_round <= 3:
        if "D" in opp_history:
            return last_opp_move
        else:
            return "C"
    
    # Middle rounds (4-7): Test opponent's tolerance
    elif current_round <= 7:
        if "D" not in opp_history:
            return "D" if random.random() < 0.2 else "C"
        else:
            if last_opp_move == "D":
                return "C" if random.random() < 0.1 else "D"
            else:
                return "C"
    
    # Late rounds (8-10): Maximize payoff based on opponent's behavior
    else:
        if opp_history.count("D") >= 3:
            return "D"
        else:
            return "C"